/** settings and widget **/
window.onload = function() {
    if (window.jQuery) {
        jQuery(document).ready(function($) {

          	// settings
            var $colorPicker = $('.daily-readings-color-picker-field');
            if ($colorPicker && $colorPicker.length > 0) {
                $colorPicker.wpColorPicker();
            }

            // settings
            $('#daily-readings-shortcode').on("click", function() {

                copyToClipboard();

                $('#daily-readings-snackbar').addClass("show");
                setTimeout(function(){ 
                    $('#daily-readings-snackbar').removeClass("show");
                }, 3000);
            });

            function copyToClipboard() {
                var $temp = $("<input>");
                $("body").append($temp);
                $temp.val($('#daily-readings-shortcode').text()).select();
                document.execCommand("copy");
                $temp.remove();
            }



            // widget
            $(document).on("click", ".daily-readings-upload_image_button", function(e) {
                e.preventDefault();
                var $button = $(this);

                var file_frame = wp.media.frames.file_frame = wp.media({
                    title: 'Select or upload image',
                    library: { 
                        type: 'image'
                    },
                    button: {
                        text: 'Select'
                    },
                    multiple: false 
                });

                
                file_frame.on('select', function() {
                    
                    var attachment = file_frame.state().get('selection').first().toJSON();

                    $input = $button.parent().siblings('div.daily-readings-input-wrapper').find('input').first();
                    $input.val(attachment.url);
                    $input.change();

                    $img = $button.parent().siblings('div.daily-readings-preview-image-wrapper').find('img').first();
                    $img.attr('src', attachment.url);

                });

                file_frame.open();
            });

            // widget
            $(document).on("click", ".daily-readings-remove_image_button", function(e) {
                e.preventDefault();
                var $button = $(this);

                $input = $button.parent().siblings('div.daily-readings-input-wrapper').find('input').first();
                $input.val('');
                $input.change();

                $img = $button.parent().siblings('div.daily-readings-preview-image-wrapper').find('img').first();
                $img.attr('src', '');

            });



            // datepicker - page
            $('#datepicker').datepicker({
                dateFormat: 'yy_mm_dd',
                showOn: "button",
                buttonImage: "https://bible-assets.s3.us-east-2.amazonaws.com/assets/calendar_icon.svg",
                buttonImageOnly: true,
                buttonText: "Select date"
            });

            $('#datepicker').change(function(e) {
                
                var newDate = $(this).val();
               
                $.get( 'https://7opmf2m7eg.execute-api.us-east-2.amazonaws.com/default/getDailyLecture?rite=' + DR_CONFIGS.rite 
                        + '&removeNumbers=' + DR_CONFIGS.hideNumbers + '&date=' + newDate + '&gmtOffset=' + DR_CONFIGS.timeZone,
                    function( response ) {
                        console.log(response);
                        $('.daily-readings-date').text(response.date);

                        $('.daily-readings-reading-heading').remove();
                        $('.daily-readings-reading').remove();
                        $('#no-readings-message').remove();

                        if(!DR_CONFIGS.hideFirstLecture && response.firstLecture){
                            buildReading(DR_CONFIGS.firstLecture, response.firstLecture);
                        }

                        if(!DR_CONFIGS.hidePsalm && response.psalm){
                            buildReading(DR_CONFIGS.psalm, response.psalm);
                        }

                        if(!DR_CONFIGS.hideSecondLecture && response.secondLecture){
                            buildReading(DR_CONFIGS.secondLecture, response.secondLecture);
                        }

                        if(!DR_CONFIGS.hideGospel && response.gospel){
                            buildReading(DR_CONFIGS.gospel, response.gospel);
                        }

                        if(!response.firstLecture && !response.psalm && !response.secondLecture && !response.gospel){
                            $('.daily-readings-wrapper').append('<div id="no-readings-message">' + DR_CONFIGS.noReadings + '</div>');
                        }
                        
                    }
                );

            });

            function buildReading(heading, reading) {
                var content = '<h4 class="daily-readings-reading-heading">' + heading + ' <span>' + reading.lecture + '</span></h4>'
                                + '<div class="daily-readings-reading">' + reading.verses + '</div>'
                
                $('.daily-readings-wrapper').append(content);
            }

        });

    }
}




/** widget **/
function readToggle(context) {
    if (window.jQuery) {
        var dots = jQuery('.daily-readings-reading.' + context + ' .daily-readings-dots');
        var moreText = jQuery('.daily-readings-reading.' + context + ' .daily-readings-read-more');
        var btnText = jQuery('#' + context + '-read-more-daily-readings i');

        if (dots.css('display') === 'none') {
            dots.css('display', 'inline');
            btnText.removeClass('fa-chevron-up');
            btnText.addClass('fa-chevron-down');
            moreText.css('display', 'none');
        } else {
            dots.css('display', 'none');
            btnText.removeClass('fa-chevron-down');
            btnText.addClass('fa-chevron-up');
            moreText.css('display', 'inline');
        }
    }
}